/*
 *   o_
 * in|tarsys GmbH (c)
 *   
 * all rights reserved
 *
 */
package de.intarsys.cloudsuite.gears.core.service.explorer.api;

import java.util.ArrayList;
import java.util.List;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;

import de.intarsys.cloudsuite.gears.core.service.common.api.DtoArtifact;
import de.intarsys.cloudsuite.gears.core.service.common.api.ResultCommon;
import de.intarsys.tools.jaxrs.ServiceParam;

@ServiceParam
@JsonIgnoreProperties(ignoreUnknown = true)
public class ResultExplorer extends ResultCommon {

	private List<String> documentNames = new ArrayList<>();

	private List<DtoArtifact> artifacts = new ArrayList<>();

	public void addArtifact(DtoArtifact artifact) {
		artifacts.add(artifact);
	}

	public List<DtoArtifact> getArtifacts() {
		return artifacts;
	}

	public List<String> getDocumentNames() {
		return documentNames;
	}

	public void setArtifacts(List<DtoArtifact> artifacts) {
		this.artifacts = artifacts;
	}

	public void setDocumentNames(List<String> documentNames) {
		this.documentNames = documentNames;
	}

}
