/*
 *   o_
 * in|tarsys GmbH (c)
 *   
 * all rights reserved
 *
 */
package de.intarsys.cloudsuite.gears.core.service.signer.api;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;

import de.intarsys.cloudsuite.gears.core.service.common.api.ResultCommon;
import de.intarsys.cloudsuite.gears.core.service.common.api.TransportDocument;
import de.intarsys.tools.jaxrs.ServiceParam;
import de.intarsys.tools.lang.LangTools;

@ServiceParam
@JsonIgnoreProperties(ignoreUnknown = true)
public class ResultSigner extends ResultCommon {

	private List<String> documentNames = new ArrayList<>();

	private List<TransportDocument> signatures;

	@Override
	public boolean equals(Object other) {
		if (!(other instanceof ResultSigner)) {
			return false;
		}
		ResultSigner otherResult = (ResultSigner) other;
		if (!LangTools.equals(documentNames, otherResult.documentNames)) {
			return false;
		}
		if (!LangTools.equals(signatures, otherResult.signatures)) {
			return false;
		}
		return true;
	}

	public List<String> getDocumentNames() {
		return documentNames;
	}

	public List<TransportDocument> getSignatures() {
		return signatures;
	}

	@Override
	public int hashCode() {
		return Objects.hash(documentNames, signatures);
	}

	public void setDocumentNames(List<String> documentNames) {
		this.documentNames = documentNames;
	}

	public void setSignatures(List<TransportDocument> signatures) {
		this.signatures = signatures;
	}
}
