/*
 *   o_
 * in|tarsys GmbH (c)
 *   
 * all rights reserved
 *
 */
package de.intarsys.cloudsuite.gears.demo.auth;

import java.security.Principal;
import java.util.Map;
import java.util.UUID;

import de.intarsys.tools.functor.Args;
import de.intarsys.tools.functor.IArgs;

public abstract class DemoPrincipal implements Principal {

	private final String name;

	private final String token = UUID.randomUUID().toString();

	public DemoPrincipal(String name) {
		super();
		this.name = name;
	}

	public abstract Map<String, Object> getClaims();

	@Override
	public String getName() {
		return name;
	}

	public String getToken() {
		return token;
	}

	public IArgs toArgs() {
		IArgs args = Args.create();
		args.put("name", getName());
		return args;
	}

}
