/*
 *   o_
 * in|tarsys GmbH (c)
 *
 * all rights reserved
 *
 */
package de.intarsys.cloudsuite.gears.demo.model;

import java.io.File;
import java.util.HashMap;
import java.util.Map;

import com.fasterxml.jackson.annotation.JsonIgnore;

import de.intarsys.tools.locator.FileLocator;
import de.intarsys.tools.locator.ILocator;

public class DemoDoc {

	private String name;

	private String path;

	private boolean signed;

	private boolean viewed;

	private boolean timestamped;

	private Map<String, String> properties = new HashMap<>();

	@JsonIgnore
	public long getLength() {
		return new File(getPath()).length();
	}

	@JsonIgnore
	public ILocator getLocator() {
		return new FileLocator(getPath());
	}

	public String getName() {
		return name;
	}

	public String getPath() {
		return path;
	}

	public Map<String, String> getProperties() {
		return properties;
	}

	public boolean isSigned() {
		return signed;
	}

	public boolean isViewed() {
		return viewed;
	}

	public void setName(String name) {
		this.name = name;
	}

	public void setPath(String path) {
		this.path = path;
	}

	public void setProperties(Map<String, String> properties) {
		this.properties = properties;
	}

	public void setSigned(boolean signed) {
		this.signed = signed;
	}

	public void setViewed(boolean viewed) {
		this.viewed = viewed;
	}

	public boolean isTimestamped() {
		return timestamped;
	}

	public void setTimestamped(boolean timestamped) {
		this.timestamped = timestamped;
	}
}
