package de.intarsys.cloudsuite.gears.demo.model;

import java.net.URI;
import java.util.Base64;

import org.ietf.jgss.GSSContext;
import org.ietf.jgss.GSSCredential;
import org.ietf.jgss.GSSException;
import org.ietf.jgss.GSSManager;
import org.ietf.jgss.GSSName;
import org.ietf.jgss.Oid;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import jakarta.ws.rs.client.Invocation.Builder;
import jakarta.ws.rs.core.HttpHeaders;

public class KerberosModifier extends CallModifier {

	private static final Logger Log = LoggerFactory.getLogger(KerberosModifier.class);

	private static Oid OID_SPNEGO;

	static {
		try {
			OID_SPNEGO = new Oid("1.3.6.1.5.5.2");
		} catch (GSSException ignore) {
			// not expected (oid string known to be valid)
		}
	}

	private final GSSCredential delegCred;

	public KerberosModifier(GSSCredential delegCred) {
		super();
		this.delegCred = delegCred;
	}

	@Override
	public void accept(Builder builder, URI target) {
		GSSManager manager = GSSManager.getInstance();
		try {
			GSSName name = manager.createName("HTTP@" + target.getHost(), GSSName.NT_HOSTBASED_SERVICE);
			GSSContext context = manager.createContext(name, OID_SPNEGO, delegCred, GSSCredential.DEFAULT_LIFETIME);
			byte[] token = context.initSecContext(new byte[0], 0, 0);
			builder.header(HttpHeaders.AUTHORIZATION, "Negotiate " + Base64.getEncoder().encodeToString(token));
		} catch (GSSException ex) {
			Log.warn(ex.getMessage(), ex);
		}
	}

}
