import { Component, OnInit } from '@angular/core';
import { ActivatedRoute } from '@angular/router';

import { SettingsService } from './settings.service';

@Component({
  selector: 'app-settings',
  templateUrl: './settings.component.html',
  styleUrls: ['./settings.component.css']
})
export class SettingsComponent implements OnInit {

  constructor(
    private route: ActivatedRoute,
    private settingsService: SettingsService
  ) {
  }

  presets: any[] = [];

  preset: any = {};

  ngOnInit() {
    this.presets = this.settingsService.presets;
    this.preset = this.settingsService.preset;
  }

  getPresetValues(): any[] {
    // avoid using "values" (not present in IE) instead of adding polyfill
    return Object.keys(this.presets).map(key => this.presets[key]).sort((a,b) => (a.id < b.id ? -1 : 1));
  }

  isBasicAuth() {
    return this.preset.settings['gears.core.auth.type'] === "basic";
  }

  onSelectPreset() {
    this.settingsService
      .setPresetId(this.preset.id)
      .subscribe(() => {
        this.presets = this.settingsService.presets;
        this.preset = this.settingsService.preset;
      });
  }

  onRemovePreset() {
    const input = confirm("Remove current preset?");
    if (!input) {
      return;
    }
    this.settingsService
      .removePreset(this.preset)
      .subscribe(() => {
        this.presets = this.settingsService.presets;
        this.preset = this.settingsService.preset;
      });
  }

  onCreatePreset() {
    const input = prompt("Enter a name for the new preset", this.preset?.id);
    if (!input || input === this.preset?.id) {
      return;
    }
    this.settingsService
      .createPreset(input)
      .subscribe(() => {
        this.presets = this.settingsService.presets;
        this.preset = this.settingsService.preset;
      });
  }

  /**
   * @param callback Used by end-to-end tests.
   */
  submit(callback?: () => void): void {
    this.settingsService
      .save(this.presets)
      .subscribe(callback);
  }
}
