
const { resolve, relative } = require('path');
const { writeFileSync } = require('fs');
let pkg = require('./package.json');
let metainfo = require('./src/app/meta.json');

metainfo.id = pkg.name;
metainfo.version = pkg.version;
metainfo.build = metainfo.build + 1;
metainfo.timestamp = (new Date).toISOString();

const file = resolve(__dirname, 'src', 'app', 'meta.json');
writeFileSync(file, `${JSON.stringify(metainfo, null, 4)}`, { encoding: 'utf-8' });

console.log(`Wrote meta info to ${relative(resolve(__dirname, '..'), file)}`);
