var uri = URI(window.location.href);
var query = uri.search(true);
var autoCancel = true;
var authContext = {};
authContext.state = query["state"];
authContext.sticky_id = query["sticky_id"];
authContext.redirectUri = query["redirectUri"];
if (!authContext.redirectUri) {
	authContext.redirectUri = query["callback"];
}
authContext.conversation = query["conversation"];
authContext.stage = query["stage"];

function checkOk(event) {
	if (event.key === 'Enter') {
		sendOk();
	}
}
function sendOk() {
	$('#form').hide();
	$('#loading').show();
	autoCancel = false;
	var request = {
		conversation: authContext.state,
		value: "nothing"
	};
	let tempUrl = toTargetUrl("../api/v1/flow/conversation/resume");
	send(tempUrl.toString(), request)//
		.done(function (response) {
			window.location.replace(response.redirectUri);
		}).fail(function (error) {
			// error page...
		});
	return false;
}
function send(url, request) {
	return $.ajax({
		url: url,
		type: "POST",
		data: JSON.stringify(request),
		contentType: "application/json"
	});
}
function handleUnload(e) {
	if (autoCancel) {
		sendCancel();
	}
}
function toTargetUrl(url) {
	let tempUrl = new URI(url);
	if (authContext.sticky_id) {
		tempUrl.setSearch("sticky_id", authContext.sticky_id);
	}
	return tempUrl;
}
document.addEventListener('DOMContentLoaded', function () {
	window.addEventListener("beforeunload", handleUnload);
	document.getElementById('formOk').addEventListener('click', sendOk);
	var request = {
		conversation: authContext.state
	};
	let tempUrl = toTargetUrl("../api/v1/flow/conversation/getParameters");
	send(tempUrl.toString(), request)
		.done(function (response) {
			var imageUrl = response.image

			$('#label').empty();
			$('#label').append(response.label);
			$('#description').empty();
			$('#description').append(response.description);

			$('#loading').hide();
			$('#form').show();
			document.getElementById('qrCode').src = imageUrl;
		})
		.fail(function (error) {
			$('#loading').hide();
			$('#failed').show();
			console.log("can not get parameters " + error);
		});
});
