package de.intarsys.cloudsuite.gears.core.service.common.api;

import java.util.LinkedHashMap;
import java.util.Map;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;

public class DtoActionTyped {

	private String type;

	private Map<String, Object> args = new LinkedHashMap<>();

	@JsonAnyGetter
	public Map<String, Object> getArgs() {
		return args;
	}

	public String getType() {
		return type;
	}

	@JsonAnySetter
	public void setArg(String name, Object value) {
		this.args.put(name, value);
	}

	public void setArgs(Map<String, Object> properties) {
		this.args = properties;
	}

	public void setType(String type) {
		this.type = type;
	}

}
