package de.intarsys.cloudsuite.gears.core.service.common.api;

import de.intarsys.tools.functor.IArgs;

/**
 * An {@link DtoArgumentDefinition} describes the manipulation of an {@link IArgs} structure.
 * 
 * This implementation:
 * 
 * - binds a path to a value.
 * 
 * The order in which {@link DtoArgumentDefinition}s are applied is important.
 * 
 */
public class DtoArgumentDefinition {

	private String path;

	private Object value;

	public DtoArgumentDefinition() {
	}

	public DtoArgumentDefinition(String path, Object value) {
		super();
		this.path = path;
		this.value = value;
	}

	public String getPath() {
		return path;
	}

	public Object getValue() {
		return value;
	}

	public void setPath(String path) {
		this.path = path;
	}

	public void setValue(Object value) {
		this.value = value;
	}

	@Override
	public String toString() {
		return path + "=" + value;
	}
}
