/*
 *   o_
 * in|tarsys GmbH (c)
 *   
 * all rights reserved
 *
 */
package de.intarsys.cloudsuite.gears.core.service.common.api;

import java.util.Objects;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;

import de.intarsys.tools.jackson.TypedDeserializer;
import de.intarsys.tools.jackson.TypedSerializer;
import de.intarsys.tools.jaxrs.ServiceParam;
import de.intarsys.tools.lang.LangTools;

/**
 * A single result artifact.
 * 
 * For a composite flow (like viewer) the result may be a list of different
 * artifacts created by different plugin action activations.
 *
 */
@ServiceParam
@JsonIgnoreProperties(ignoreUnknown = true)
public class DtoArtifact {

	@JsonDeserialize(using = TypedDeserializer.class)
	@JsonSerialize(using = TypedSerializer.class)
	private Object value;

	@JsonInclude(Include.NON_EMPTY)
	private String id;

	@JsonInclude(Include.NON_EMPTY)
	private String role;

	public DtoArtifact() {
	}

	public DtoArtifact(Object value) {
		this.value = value;
	}

	public DtoArtifact(String id, Object value) {
		this.id = id;
		this.value = value;
	}

	@Override
	public boolean equals(Object other) {
		if (!(other instanceof DtoArtifact)) {
			return false;
		}
		DtoArtifact otherArtifact = (DtoArtifact) other;
		if (!LangTools.equals(this.id, otherArtifact.id)) {
			return false;
		}
		if (!LangTools.equals(this.role, otherArtifact.role)) {
			return false;
		}
		return LangTools.equals(this.value, otherArtifact.value);
	}

	public String getId() {
		return id;
	}

	public String getRole() {
		return role;
	}

	public Object getValue() {
		return value;
	}

	@Override
	public int hashCode() {
		return Objects.hash(id, role, value);
	}

	public void setId(String id) {
		this.id = id;
	}

	public void setRole(String role) {
		this.role = role;
	}

	public void setValue(Object result) {
		this.value = result;
	}
}
