package de.intarsys.cloudsuite.gears.core.service.common.api;

import java.util.List;
import java.util.Map;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;

import de.intarsys.tools.functor.Args;
import de.intarsys.tools.functor.IArgs;
import de.intarsys.tools.jackson.ArgsToJavaConverter;
import de.intarsys.tools.jackson.JavaToArgsConverter;

public class DtoConfiguration {

	@JsonInclude(Include.NON_NULL)
	private String id;

	@JsonInclude(Include.NON_NULL)
	private String label;

	@JsonInclude(Include.NON_NULL)
	private String description;

	@JsonInclude(Include.NON_EMPTY)
	private List<DtoPluginSpec> plugins;

	@JsonInclude(Include.NON_EMPTY)
	private Map settings;

	@JsonInclude(Include.NON_EMPTY)
	private List<DtoArgumentDefinition> arguments;

	@JsonInclude(Include.NON_EMPTY)
	private List<Object> widgets;

	@JsonInclude(Include.NON_EMPTY)
	private List<Object> actions;

	@JsonInclude(value = Include.NON_EMPTY)
	@JsonSerialize(converter = ArgsToJavaConverter.class)
	@JsonDeserialize(converter = JavaToArgsConverter.class)
	private IArgs variables = Args.create();

	public DtoConfiguration() {
	}

	public DtoConfiguration(String id) {
		super();
		this.id = id;
	}

	public List<Object> getActions() {
		return actions;
	}

	public List<DtoArgumentDefinition> getArguments() {
		return arguments;
	}

	public String getDescription() {
		return description;
	}

	public String getId() {
		return id;
	}

	public String getLabel() {
		return label;
	}

	public List<DtoPluginSpec> getPlugins() {
		return plugins;
	}

	public IArgs getVariables() {
		return variables;
	}

	public List<Object> getWidgets() {
		return widgets;
	}

	public void setActions(List<Object> actions) {
		this.actions = actions;
	}

	public void setArguments(List<DtoArgumentDefinition> argumentDefinitions) {
		this.arguments = argumentDefinitions;
	}

	public void setDescription(String description) {
		this.description = description;
	}

	public void setId(String id) {
		this.id = id;
	}

	public void setLabel(String label) {
		this.label = label;
	}

	public void setPlugins(List<DtoPluginSpec> plugins) {
		this.plugins = plugins;
	}

	public void setVariables(IArgs variables) {
		this.variables = variables;
	}

	public void setWidgets(List<Object> widgetDefinitions) {
		this.widgets = widgetDefinitions;
	}

}
