package de.intarsys.cloudsuite.gears.core.service.common.api;

import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;

public class DtoConfigurations extends ArrayList<DtoConfiguration> {

	public void addConfiguration(DtoConfiguration configuration) {
		add(configuration);
	}

	public DtoConfiguration getConfiguration(String id) {
		return stream().filter(config -> config.getId().equals(id)).findFirst().orElse(null);
	}

	public List<DtoConfiguration> getConfigurations() {
		return this;
	}

	public void merge(DtoConfigurations other) {
		ListIterator<DtoConfiguration> it = this.listIterator();
		while (it.hasNext()) {
			DtoConfiguration config = it.next();
			DtoConfiguration otherConfig = other.getConfiguration(config.getId());
			if (otherConfig != null) {
				it.set(otherConfig);
				other.remove(otherConfig);
			}
		}
		addAll(other);
	}

}
