package de.intarsys.cloudsuite.gears.core.service.common.api;

import java.util.HashMap;
import java.util.Map;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;

import de.intarsys.tools.jaxrs.ServiceParam;

@ServiceParam
@JsonIgnoreProperties(ignoreUnknown = true)
public class DtoFieldValues {

	protected Map<String, Object> values = new HashMap<>();

	public DtoFieldValues() {
		super();
	}

	public Object getValue(String name) {
		return values.get(name);
	}

	@JsonAnyGetter
	public Map<String, Object> getValues() {
		return values;
	}

	@JsonAnySetter
	public void setValue(String name, Object value) {
		values.put(name, value);
	}

	public void setValues(Map<String, Object> values) {
		this.values = values;
	}

}