package de.intarsys.cloudsuite.gears.core.service.common.api;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;

import de.intarsys.tools.functor.IArgs;
import de.intarsys.tools.jackson.ArgsToJavaConverter;
import de.intarsys.tools.jackson.JavaToArgsConverter;

public class DtoPluginSpec {

	private String factory;

	@JsonInclude(value = Include.NON_EMPTY)
	@JsonSerialize(converter = ArgsToJavaConverter.class)
	@JsonDeserialize(converter = JavaToArgsConverter.class)
	private IArgs args;

	public IArgs getArgs() {
		return args;
	}

	public String getFactory() {
		return factory;
	}

	public void setArgs(IArgs args) {
		this.args = args;
	}

	public void setFactory(String id) {
		this.factory = id;
	}

	public void setId(String id) {
		this.factory = id;
	}

}
