/*
 *   o_
 * in|tarsys GmbH (c)
 *   
 * all rights reserved
 *
 */
package de.intarsys.cloudsuite.gears.core.service.common.api;

import java.util.ArrayList;
import java.util.List;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;

import de.intarsys.tools.jaxrs.ServiceParam;

/**
 * Validation data collected during a signing process.
 * 
 */
@ServiceParam
@JsonIgnoreProperties(ignoreUnknown = true)
public class DtoValidationData {

	private List<byte[]> ocspResponses = new ArrayList<>();

	private List<byte[]> crls = new ArrayList<>();

	private List<byte[]> certificates = new ArrayList<>();

	public DtoValidationData() {
		super();
	}

	public void addCertificate(byte[] certificate) {
		certificates.add(certificate);
	}

	public void addCrl(byte[] crl) {
		crls.add(crl);
	}

	public void addOcspResponse(byte[] ocspResponse) {
		ocspResponses.add(ocspResponse);
	}

	public List<byte[]> getCertificates() {
		return certificates;
	}

	public List<byte[]> getCrls() {
		return crls;
	}

	public List<byte[]> getOcspResponses() {
		return ocspResponses;
	}

	public void setCertificates(List<byte[]> certificates) {
		this.certificates = certificates;
	}

	public void setCrls(List<byte[]> crls) {
		this.crls = crls;
	}

	public void setOcspResponses(List<byte[]> ocspResponses) {
		this.ocspResponses = ocspResponses;
	}

}
