/*
 *   o_
 * in|tarsys GmbH (c)
 *   
 * all rights reserved
 *
 */
package de.intarsys.cloudsuite.gears.core.service.common.api;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;

import de.intarsys.tools.functor.ArgTools;
import de.intarsys.tools.functor.Args;
import de.intarsys.tools.functor.IArgs;
import de.intarsys.tools.jackson.ArgsToJavaConverter;
import de.intarsys.tools.jackson.JavaToArgsConverter;
import de.intarsys.tools.jaxrs.ServiceRequest;

/**
 * An abstract superclass for flow creating requests.
 *
 */
@ServiceRequest
public abstract class RequestFlowCreate implements IOptionSupport {

	@JsonInclude(value = Include.NON_EMPTY)
	@JsonSerialize(converter = ArgsToJavaConverter.class)
	@JsonDeserialize(converter = JavaToArgsConverter.class)
	private IArgs options = Args.create();

	@JsonInclude(value = Include.NON_EMPTY)
	@JsonSerialize(converter = ArgsToJavaConverter.class)
	@JsonDeserialize(converter = JavaToArgsConverter.class)
	private IArgs variables = Args.create();

	@JsonInclude(value = Include.NON_EMPTY)
	@JsonSerialize(converter = ArgsToJavaConverter.class)
	@JsonDeserialize(converter = JavaToArgsConverter.class)
	private IArgs args = Args.create();

	@JsonInclude(value = Include.NON_EMPTY)
	private Object configuration;

	@JsonInclude(value = Include.NON_EMPTY)
	private String label;

	public IArgs getArgs() {
		if (args == null) {
			args = Args.create();
		}
		return args;
	}

	public Object getConfiguration() {
		return configuration;
	}

	public String getLabel() {
		return label;
	}

	@Override
	public Object getOption(String name) {
		if (options == null) {
			return null;
		}
		return ArgTools.getPath(options, name);
	}

	public IArgs getOptions() {
		return options;
	}

	public Object getVariable(String name) {
		if (variables == null) {
			return null;
		}
		return ArgTools.getPath(variables, name);
	}

	public IArgs getVariables() {
		return variables;
	}

	public void setArg(String name, Object value) {
		if (args == null) {
			args = Args.create();
		}
		ArgTools.putPath(args, name, value);
	}

	public void setArgs(IArgs args) {
		this.args = args;
	}

	public void setConfiguration(Object configuration) {
		this.configuration = configuration;
	}

	public void setLabel(String label) {
		this.label = label;
	}

	@Override
	public void setOption(String name, Object value) {
		if (options == null) {
			options = Args.create();
		}
		ArgTools.putPath(options, name, value);
	}

	public void setOptions(IArgs options) {
		this.options = options;
	}

	public void setVariable(String name, Object value) {
		if (variables == null) {
			variables = Args.create();
		}
		ArgTools.putPath(variables, name, value);
	}

	public void setVariables(IArgs variables) {
		this.variables = variables;
	}
}
