/*
 *   o_
 * in|tarsys GmbH (c)
 *   
 * all rights reserved
 *
 */
package de.intarsys.cloudsuite.gears.core.service.common.api;

import java.util.ArrayList;
import java.util.List;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;

import de.intarsys.cloudsuite.gears.core.service.common.jackson.TransportFolderLocatorPathDeserializer;
import de.intarsys.cloudsuite.gears.core.service.common.jackson.TransportItemLocatorHandleDeserializer;
import de.intarsys.cloudsuite.gears.core.service.common.jackson.TransportItemLocatorHandleSerializer;
import de.intarsys.cloudsuite.gears.core.service.common.jackson.TransportItemLocatorPathSerializer;
import de.intarsys.tools.jaxrs.ServiceParam;
import de.intarsys.tools.locator.ILocator;
import de.intarsys.tools.string.StringTools;

/**
 * A "folder" type item to be transported to or from a cloudsuite service.
 *
 */
@ServiceParam
public class TransportFolder extends TransportItem {

	public static class TransportFolderBuilder extends TransportItemBuilder<TransportFolder> {

		protected List<TransportItem> items = new ArrayList<>();

		protected ILocator path;

		protected ILocator handle;

		@Override
		public TransportFolder build() {
			TransportFolder result = super.build();
			if (path != null) {
				result.setPath(path);
			}
			if (handle != null) {
				result.setHandle(handle);
			}
			for (TransportItem item : items) {
				result.addItem(item);
			}
			return result;
		}

		@Override
		protected TransportFolder createResult() {
			return new TransportFolder();
		}

		public TransportFolderBuilder handle(ILocator handle) {
			this.handle = handle;
			return this;
		}

		public TransportFolderBuilder item(TransportItem item) {
			this.items.add(item);
			return this;
		}

		@Override
		public TransportFolderBuilder name(String name) {
			return (TransportFolderBuilder) super.name(name);
		}

		public TransportFolderBuilder path(ILocator locator) {
			this.path = locator;
			return this;
		}

		@Override
		public TransportFolderBuilder property(String name, Object value) {
			return (TransportFolderBuilder) super.property(name, value);
		}

	}

	public static TransportFolderBuilder builder() {
		return new TransportFolderBuilder();
	}

	@JsonInclude(Include.NON_EMPTY)
	private List<TransportItem> items = new ArrayList<>();

	@JsonSerialize(using = TransportItemLocatorPathSerializer.class)
	@JsonDeserialize(using = TransportFolderLocatorPathDeserializer.class)
	@JsonInclude(Include.NON_NULL)
	private ILocator path;

	@JsonSerialize(using = TransportItemLocatorHandleSerializer.class)
	@JsonDeserialize(using = TransportItemLocatorHandleDeserializer.class)
	@JsonInclude(Include.NON_NULL)
	private ILocator handle;

	@JsonIgnore
	private ILocator locator;

	public TransportFolder() {
	}

	public TransportFolder(String name) {
		super(name);
	}

	public void addItem(TransportItem item) {
		if (item.isLink()) {
			throw new IllegalArgumentException("folder cannot contain a link");
		}
		items.add(item);
		item.setParent(this);
	}

	public ILocator getHandle() {
		return handle;
	}

	public List<TransportItem> getItems() {
		return items;
	}

	@Override
	public ILocator getLocator() {
		return locator;
	}

	public ILocator getPath() {
		return path;
	}

	@Override
	public String getType() {
		return "f";
	}

	@Override
	public boolean isFolder() {
		return true;
	}

	@Override
	public boolean isLink() {
		return handle != null;
	}

	@Override
	public void setContent(ILocator locator) {
		// ignore
	}

	@Override
	public void setHandle(ILocator locator) {
		this.handle = locator;
		setLocator(locator);
	}

	protected void setLocator(ILocator locator) {
		if (StringTools.isEmpty(basicGetName()) && locator != null) {
			setName(locator.getName());
		}
		this.locator = locator;
	}

	@Override
	public void setPath(ILocator locator) {
		this.path = locator;
		setLocator(locator);
	}
}
