/*
 *   o_
 * in|tarsys GmbH (c)
 *   
 * all rights reserved
 *
 */
package de.intarsys.cloudsuite.gears.core.service.common.jackson;

import java.io.IOException;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;

import de.intarsys.cloudsuite.gears.core.service.common.api.TransportDocument;
import de.intarsys.cloudsuite.gears.core.service.common.api.TransportFolder;

/**
 * The TransportItem deserialization mechanics can be tweaked by injecting an
 * object implementing this interface.
 * 
 * The object is called back after creation (before property setting) and after
 * all properties are set.
 *
 */
public interface ITransportItemDeserializerCallback {

	/**
	 * The TransportDocument was just created.
	 * 
	 * @param doc
	 * @param parser
	 * @param ctxt
	 * @throws IOException
	 */
	void transportDocumentCreated(TransportDocument doc, JsonParser parser, DeserializationContext ctxt)
			throws IOException;

	/**
	 * All TransportDocument properties are set.
	 * 
	 * @param doc
	 * @param parser
	 * @param ctxt
	 * @throws IOException
	 */
	void transportDocumentDeserialized(TransportDocument doc, JsonParser parser, DeserializationContext ctxt)
			throws IOException;

	/**
	 * The TransportFolder was just created.
	 * 
	 * @param doc
	 * @param parser
	 * @param ctxt
	 * @throws IOException
	 */
	void transportFolderCreated(TransportFolder folder, JsonParser parser, DeserializationContext ctxt)
			throws IOException;

	/**
	 * All TransportFolder properties are set.
	 * 
	 * @param doc
	 * @param parser
	 * @param ctxt
	 * @throws IOException
	 */
	void transportFolderDeserialized(TransportFolder folder, JsonParser parser, DeserializationContext ctxt)
			throws IOException;

}
