/*
 *   o_
 * in|tarsys GmbH (c)
 *   
 * all rights reserved
 *
 */
package de.intarsys.cloudsuite.gears.core.service.common.jackson;

import java.io.IOException;
import java.io.OutputStream;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;

import de.intarsys.tools.locator.ILocator;

/**
 * The TransportItem deserialization mechanics can be tweaked by injecting an
 * object implementing this interface.
 * 
 * This object gets called when the deserialization of streamed content is
 * encountered. You can return an ILocator whose {@link OutputStream} is used
 * directly to stream the content to.
 *
 */
public interface ITransportItemLocatorFactory {

	ILocator createLocator(JsonParser parser, DeserializationContext ctxt) throws IOException;

}
