/*
 *   o_
 * in|tarsys GmbH (c)
 *   
 * all rights reserved
 *
 */
package de.intarsys.cloudsuite.gears.core.service.common.jackson;

import java.io.IOException;
import java.io.OutputStream;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import com.fasterxml.jackson.core.Base64Variant;
import com.fasterxml.jackson.core.Base64Variants;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;

import de.intarsys.tools.locator.ILocator;

/**
 * This is the deserializer for literal document content.
 *
 * The context {@link ITransportItemLocatorFactory} is used to create the target
 * locator, then all content data is streamed into it.
 *
 */
public class TransportDocumentLocatorContentDeserializer extends TransportDocumentLocatorDeserializer {

	private static final Logger Log = LoggerFactory.getLogger(TransportDocumentLocatorContentDeserializer.class);

	protected TransportDocumentLocatorContentDeserializer() {
		super(ILocator.class);
	}

	@Override
	public ILocator deserialize(JsonParser parser, DeserializationContext ctxt) throws IOException {
		ITransportItemLocatorFactory factory = getLocatorFactory(ctxt);
		if (factory == null) {
			factory = getLocatorFactory();
		}

		ILocator locator = factory.createLocator(parser, ctxt);
		Base64Variant variant = Base64Variants.getDefaultVariant();
		try (OutputStream os = locator.getOutputStream()) {
			int read = parser.readBinaryValue(variant, os);
			Log.debug("{} deserialized {} with {} bytes", getClass(), locator.getName(), read);
		}

		return locator;
	}
}