/*
 *   o_
 * in|tarsys GmbH (c)
 *   
 * all rights reserved
 *
 */
package de.intarsys.cloudsuite.gears.core.service.common.jackson;

import java.io.IOException;
import java.io.InputStream;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.ser.std.StdSerializer;

import de.intarsys.tools.locator.ILocator;

/**
 * This is a serializer for all literal document content.
 *
 * The source locator content is physically copied to the transport stream.
 *
 */
public class TransportDocumentLocatorContentSerializer extends StdSerializer<ILocator> {
	private static final Logger Log = LoggerFactory.getLogger(TransportDocumentLocatorContentSerializer.class);

	public TransportDocumentLocatorContentSerializer() {
		super(ILocator.class);
	}

	@Override
	public void serialize(ILocator locator, JsonGenerator gen, SerializerProvider provider) throws IOException {
		try (InputStream is = locator.getInputStream()) {
			int written = gen.writeBinary(is, -1);
			Log.debug("{} serialized {} with {} bytes", getClass(), locator.getName(), written);
		}
	}
}
