/*
 *   o_
 * in|tarsys GmbH (c)
 *   
 * all rights reserved
 *
 */
package de.intarsys.cloudsuite.gears.core.service.common.jackson;

import java.io.IOException;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.cfg.ContextAttributes;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;

import de.intarsys.cloudsuite.gears.core.service.common.api.TransportDocument;
import de.intarsys.tools.locator.ByteArrayLocator;
import de.intarsys.tools.locator.ILocator;

/**
 * An abstract superclass for implementing document locator deserializers that
 * copy content to a dedicated locator on the target side.
 *
 */
public abstract class TransportDocumentLocatorDeserializer extends StdDeserializer<ILocator> {

	private static final String ATTR_LOCATOR_FACTORY = "locatorFactory";

	private static ITransportItemLocatorFactory LocatorFactory = new ITransportItemLocatorFactory() {
		@Override
		public ILocator createLocator(JsonParser parser, DeserializationContext ctxt) throws IOException {
			TransportDocument bean = (TransportDocument) parser.getCurrentValue();
			return new ByteArrayLocator(new byte[0], bean.getName());
		}
	};

	public static ITransportItemLocatorFactory getLocatorFactory() {
		return LocatorFactory;
	}

	public static ITransportItemLocatorFactory getLocatorFactory(DeserializationContext ctxt) {
		return (ITransportItemLocatorFactory) ctxt.getAttribute(ATTR_LOCATOR_FACTORY);
	}

	public static ContextAttributes setLocatorFactory(ContextAttributes attrs, ITransportItemLocatorFactory factory) {
		return attrs.withSharedAttribute(ATTR_LOCATOR_FACTORY, factory);
	}

	public static void setLocatorFactory(ITransportItemLocatorFactory locatorFactory) {
		if (locatorFactory == null) {
			throw new IllegalArgumentException("factory cannot be null");
		}
		LocatorFactory = locatorFactory;
	}

	public TransportDocumentLocatorDeserializer(Class vc) {
		super(vc);
	}

	public TransportDocumentLocatorDeserializer(JavaType valueType) {
		super(valueType);
	}

	public TransportDocumentLocatorDeserializer(StdDeserializer src) {
		super(src);
	}

}