/*
 *   o_
 * in|tarsys GmbH (c)
 *   
 * all rights reserved
 *
 */
package de.intarsys.cloudsuite.gears.core.service.common.jackson;

import java.io.IOException;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;

import de.intarsys.tools.locator.ILocator;

/**
 * This is the deserializer for referenced document content.
 * 
 * The context {@link ITransportItemLocatorFactory} is used to create the target
 * locator, then all referenced data is streamed into it. The reference must be
 * a valid locator string.
 *
 */
public class TransportDocumentLocatorPathDeserializer extends TransportDocumentLocatorDeserializer {

	protected TransportDocumentLocatorPathDeserializer() {
		super(ILocator.class);
	}

	@Override
	public ILocator deserialize(JsonParser parser, DeserializationContext ctxt) throws IOException {
		throw new IOException("document by reference not yet supported ");
		//
		// ITransportItemLocatorFactory factory = getLocatorFactory(ctxt);
		// if (factory == null) {
		// factory = getLocatorFactory();
		// }
		// ILocator outputLocator = factory.createLocator(parser, ctxt);
		// String fullname = parser.getValueAsString();
		// ILocator inputLocator = LocatorFactory.get().createLocator(fullname);
		// InputStream is = inputLocator.getInputStream();
		// OutputStream os = outputLocator.getOutputStream();
		// StreamTools.copyStream(is, os);
		// Log.debug("{} deserialized {} with {} bytes", getClass(),
		// outputLocator.getName(), outputLocator.getLength());
		// return outputLocator;
	}
}