/*
 *   o_
 * in|tarsys GmbH (c)
 *   
 * all rights reserved
 *
 */
package de.intarsys.cloudsuite.gears.core.service.common.jackson;

import java.io.IOException;
import java.net.URI;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;

import de.intarsys.tools.locator.ILocator;
import de.intarsys.tools.locator.URILocator;

/**
 * This is the deserializer for all items using handle style locators.
 * 
 * The handle is an opaque locator to some resource on the sender side, the
 * receiver is not able to interpret and physically use it.
 *
 */
public class TransportItemLocatorHandleDeserializer extends StdDeserializer<ILocator> {

	protected TransportItemLocatorHandleDeserializer() {
		super(ILocator.class);
	}

	@Override
	public ILocator deserialize(JsonParser parser, DeserializationContext ctxt) throws IOException {
		String fullname = parser.getValueAsString();
		ILocator locator = new URILocator(URI.create(fullname));
		return locator;
	}
}