/*
 *   o_
 * in|tarsys GmbH (c)
 *   
 * all rights reserved
 *
 */
package de.intarsys.cloudsuite.gears.core.service.common.jackson;

import java.io.IOException;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.ser.std.StdSerializer;

import de.intarsys.tools.locator.ILocator;

/**
 * This is a serializer for all handle style locators.
 * 
 * A handle will never be dereferenced at the target side. It may only be used
 * as an opaque object to reference items on the remote side.
 *
 */
public class TransportItemLocatorHandleSerializer extends StdSerializer<ILocator> {

	public TransportItemLocatorHandleSerializer() {
		super(ILocator.class);
	}

	@Override
	public void serialize(ILocator locator, JsonGenerator gen, SerializerProvider provider) throws IOException {
		if (locator == null || locator.toURI() == null) {
			gen.writeNull();
		} else {
			gen.writeString(locator.toURI().toString());
		}
	}

}
