/*
 *   o_
 * in|tarsys GmbH (c)
 *   
 * all rights reserved
 *
 */
package de.intarsys.cloudsuite.gears.core.service.common.jackson;

import java.io.IOException;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.ser.std.StdSerializer;

import de.intarsys.tools.locator.ILocator;

/**
 * This is a serializer for all reference style locators.
 * 
 * A references can be used to exchange items "by reference". The locator is not
 * opaque, it must be a interpretable / dereferencable at the target side.
 *
 */
public class TransportItemLocatorPathSerializer extends StdSerializer<ILocator> {

	public TransportItemLocatorPathSerializer() {
		super(ILocator.class);
	}

	@Override
	public void serialize(ILocator locator, JsonGenerator gen, SerializerProvider provider) throws IOException {
		if (locator == null || locator.toURI() == null) {
			gen.writeNull();
		} else {
			gen.writeString(locator.toURI().toString());
		}
	}

}
