async function post(url, body) {
	const response = await fetch(url, {
		method: 'POST',
		headers: {
			'Content-Type': 'application/json',
			'Accept': 'application/json'
		},
		body: JSON.stringify(body)
	});

	if (response.ok) {
		try {
			return await response.json();
		} catch (error) {
			throw new Error('Malformed JSON response', { cause: error });
		}
	}

	throw new Error(`POST request failed with status ${response.status}`);
}

function submit(uri, data) {
	const form = document.forms['request'];
	form.action = uri;
	form['data'].value = JSON.stringify(data);
	form.submit();
}

function getConversation() {
	const params = new URLSearchParams(window.location.search);
	const conversation = params.get('state');
	if (!conversation) {
		throw new Error('We are not in a conversation!');
	}

	return conversation;
}

async function redirectToAuthentication() {
	try {
		const conversation = getConversation();
		const { uri, ...request } = await post('../api/upreg/getAuthenticateRequest', { conversation });
		submit(uri, request);
	} catch (error) {
		post('../api/upreg/authenticationFailed', { cause: error });
	}

}

redirectToAuthentication();