A configuration summarizes common properties that apply to a whole set of service calls and allows for a central 
definition of these properties instead of sending them along all the time.

Typical applications of a configuration are:

* Define a common set of arguments that are always used together in this scenario, e.g. a complex setup of signature arguments
* Define a common set of widgets that are visible in this scenario

A configuration is either 

* a plain string referencing a pre-configured configuration (e.g. "demoPlain")
* a serialized configuration object (DtoConfiguration) , e.g.
```
{
	"variables": {
		"foo": "bar"
	}
}
```
* an array thereof. The resulting effective configuration is the concatenation of all configurations in the array. Configurations
with a higher position have a higher precedence, and may override definitions from earlier configurations.

Which configurations are available to your client depends on your system setup. A typical demo installation provides for example the following configurations for a signer flow:

* 'demoPlain'
Sign using a local key pair, created per installation

* 'demoBridge'
Sign using the cloud suite bridge smartcard access feature.