This is the result of a *signer* flow.

After creation of an *signer* flow using "/v1/flow/signer/create" you will receive a conversational response. The conversation will eventually end in a final state. The DtoResultStage of a *signer* flow will wrap this data structure.

This result data structure is document driven. If for any document there's additional information related to the signature operation, the information will be provided via the "properties" member of the TransportDocument. This is intentional to keep the structure simple for the standard use case.

## TransportDocument generic result properties

### signature.targetName

The name of the input document that is signed by this signature container. For detached signatures you can use this name to link to the original document that is the target of the signature.


<!---
### signature.certificate
--->

## Examples

This is the result of signing two document, one a PDF and the second a TXT file.

```
{
"signatures": [
	{
		"type": "d",
		"name": "mydoc.pdf",
		"content": "<base64 content>",
		"properties": {
			"signature": {
				"targetName": "mydoc.pdf"
			}			
		}
	},
	{
		"type": "d",
		"name": "foo.txt.p7s",
		"content": "<base64 content>",
		"properties": {
			"signature": {
				"targetName": "foo.txt"
			}
		}
	}
]
}

```

For reference purposes we show a complete conversational result as received at the end of a signer flow

```
{
	"scheme": "urn:intarsys:names:conversation:1.0:schemes:Result",
	"id": 222,
	"result": {
		"@class": "de.intarsys.cloudsuite.gears.core.service.signer.api.ResultSigner",
		"value": {
			"documentNames": [ "mydoc.pdf", "foo.txt" ],
			"signatures": [
				{
					"type": "d",
					"name": "mydoc.pdf",
					"content": "<base64 content>",
					"properties": {
						"signature": {
							"targetName": "mydoc.pdf"
						}			
					}
				},
				{
					"type": "d",
					"name": "foo.txt.p7s",
					"content": "<base64 content>",
					"properties": {
						"signature": {
							"targetName": "foo.txt"
						} 
					}
				}
			]
		}
	}
}
```
