var uri = URI(window.location.href);
var query = uri.search(true);
var autoCancel = true;
var authContext = {};
authContext.state = query["state"];
authContext.sticky_id = query["sticky_id"];
authContext.redirectUri = query["redirectUri"];
if (!authContext.redirectUri) {
	authContext.redirectUri = query["callback"];
}
authContext.conversation = query["conversation"];
authContext.stage = query["stage"];
/*
uri.removeSearch("state");
uri.removeSearch("redirectUri");
uri.removeSearch("callback");
uri.removeSearch("conversation");
uri.removeSearch("stage");
window.history.replaceState({}, "", uri.toString());
 */

function checkOk(event) {
	if(event.key === 'Enter') {
		sendOk();
	}
}
function sendOk() {
	autoCancel = false;
	var request = {
		state: authContext.state,
		value: $('#pin').val()
	};
	let tempUrl = toTargetUrl("../api/v1/authentication/credential/setPin");
	send(tempUrl.toString(), request)//
		.done(function(response) {
			window.location.replace(response.redirectUri);
		}).fail(function(error) {
			// error page...
		});
	return false;
}
function sendCancel() {
	autoCancel = false;
	var request = {
		state: authContext.state
	};
	let tempUrl = toTargetUrl("../api/v1/authentication/credential/cancel");
	send(tempUrl.toString(), request)//
		.done(function(response) {
			window.location.replace(response.redirectUri);
		}).fail(function(error) {
			// error page...
		});
	return false;
}
function send(url, request) {
	return $.ajax({
		url: url,
		type: "POST",
		data: JSON.stringify(request),
		contentType: "application/json"
	});
}
function handleUnload(e) {
	if (autoCancel) {
		sendCancel();
	}
}
function toTargetUrl(url) {
	let tempUrl = new URI(url);
	if (authContext.sticky_id) {
		tempUrl.setSearch("sticky_id", authContext.sticky_id);
	}
	return tempUrl;
}
document.addEventListener('DOMContentLoaded', function() {
	window.addEventListener("beforeunload", handleUnload);
	document.getElementById('pin').addEventListener('keyup', checkOk);
	document.getElementById('formOk').addEventListener('click', sendOk);
	document.getElementById('formCancel').addEventListener('click', sendCancel);
	var request = {
		state: authContext.state
	};
	let tempUrl = toTargetUrl("../api/v1/authentication/getPinParameters");
	send(tempUrl.toString(), request)// 
		.done(function(response) {
			$('#authLabel').empty();
			$('#authLabel').append(response.label);
			$('#authDescription').empty();
			$('#authDescription').append(response.description);
			$('#loading').hide();
			$('#form').show();
			const toBeFocused = $('#pin');
			toBeFocused.focus();
			if (toBeFocused instanceof HTMLInputElement) {
				toBeFocused.select();
			}
		})
		.fail(function(error) {
			$('#loading').hide();
			$('#failed').show();
			console.log("can not get parameters " + error);
		});
});
