
var uri = URI(window.location.href);
var query = uri.search(true);
var autoCancel = true;
var authContext = {};
authContext.state = query["state"];
authContext.sticky_id = query["sticky_id"];
authContext.redirectUri = query["redirectUri"];
if (!authContext.redirectUri) {
	authContext.redirectUri = query["callback"];
}
authContext.conversation = query["conversation"];
authContext.stage = query["stage"];
window.addEventListener("beforeunload", handleUnload);
function sendOk(resultValue) {
	autoCancel = false;
	var request = {
		state: authContext.state,
		response: resultValue.response,
		certificate: resultValue.certificate
	};
	let tempUrl = toTargetUrl("../api/v1/authentication/credential/setResponse");
	return send(tempUrl.toString(), request)// 
		.done(function(response) {
			window.location.replace(response.redirectUri);
		}).fail(function(error) {
			// error page...
		});
}
function sendCancel() {
	autoCancel = false;
	var request = {
		state: authContext.state
	};
	let tempUrl = toTargetUrl("../api/v1/authentication/credential/cancel");
	return send(tempUrl.toString(), request)// 
		.done(function(response) {
			window.location.replace(response.redirectUri);
		}).fail(function(error) {
			// error page...
		});
} 
function send(url, request) {
	return $.ajax({
		url: url,
		type: "POST",
		data: JSON.stringify(request),
		contentType: "application/json"
	});
}
function handleUnload(e) {
	if (autoCancel) {
		sendCancel();
	}
}
function toTargetUrl(url) {
	let tempUrl = new URI(url);
	if (authContext.sticky_id) {
		tempUrl.setSearch("sticky_id", authContext.sticky_id);
	}
	return tempUrl;
}
var request = {
	state: authContext.state
};
var bridge_states = {
	Created: {
		label: $('<div><p>bridge created</p></div>'),
		todo: $('<div><p>nothing</p></div>')
	},
	Connecting: {
		label: $('<div>' //
			+ '<p>Connecting to bridge agent...</p>' //
			+ '<button class="btn btn-default" onclick="bridge.dispose(); return false;">Cancel</button>' //
			+ '</div>'),
		todo: $('')
	},
	Connected: {
		label: $('<p>Connected to bridge agent.</p>'),
		todo: $('<div><p>nothing</p></div>')
	},
	Disposed: {
		label: $('<p class="text-danger">Bridge was disposed.</p>'),
		todo: $('<div><p>restart</p></div>')
	},
	ConnectionFailed: {
		label: $('<div>' //
			+ '<p>Not connected to bridge agent. Will retry shortly.</p>' //
			+ '<button class="btn btn-default" onclick="bridge.dispose(); return false;">Cancel</button>' //
			+ '</div>'),
		todo: $('')
	},
	ConnectionLost: {
		label: $('<div>' //
			+ '<p class="text-danger">Connection to bridge agent lost.</p>' //
			+ '</div>'),
		todo: $('<div><p>restart</p></div>')
	}
};
var agent_states = {
	existing: {
		label: $('<p>Existing bridge agent.</p>'),
		todo: $('<p></p>')
	},
	launchAuto: {
		label: $('<p>"Web Start" bridge agent...</p>'),
		todo: $('<p>If a dialog appears requesting confirmation to Web Start the bridge, you should confirm.</p>')
	},
	launchAutoSuccess: {
		label: $('<p>"Web Start" bridge agent...</p>'),
		todo: $('<p>Web Start finished - Wait for local bridge agent...</p>')
	},
	launchManual: {
		label: $('<p>Manually started bridge agent.</p>'),
		todo: $('<p>Now we try downloading a small launcher file that enables ' //
			+ 'you to manually "web start" the local agent.</p>' //
			+ '<p>If your browser supports automatic download &amp; launching ' //
			+ 'of JNLP files, you should shortly be prompted to install the local ' //
			+ 'agent via JNLP.</p>' //
			+ '<p>If your browser does not support this (like Chrome or Edge) you will ' //
			+ 'be asked if you want to download the "bridge.jnlp" file. You ' //
			+ 'should confirm to do so. After downloading you can manually start ' //
			+ 'the download &amp; launching of the local agent manually in your ' //
			+ 'browser.</p>')
	},
	unknown: {
		label: $('<p>We cannot find or install a bridge agent.</p>'),
		todo: $('<p></p>')
	}
};

function updateInstructions(bridge) {
	var stateDescription = bridge_states[bridge.state];
	var agentDescription = agent_states[bridge.agentState];

	$('#instructions_connection').empty();
	$('#instructions_agent').empty();
	$('#instructions_task').empty();

	$('#instructions_task').append(stateDescription.todo);
	$('#instructions_task').append(agentDescription.todo);

	$('#instructions_connection').append(stateDescription.label);
	$('#instructions_agent').append(agentDescription.label);

	if (bridge.agentState === 'launchManual') {
		if ($("#download").length == 0) {
			$('#instructions_agent')
				.parent()
				.append(
					$('<iframe id="download" style="display:none" src="../CloudSuiteBridge/bridge.jnlp.jsp"></iframe>'));
		}
	}
};

function startBridge(bridgeParams) {
	// this will be called in case bridge agent can not be detected
	var launchFunction = function(bridge) {
		return csBridge.util.launchJNLP(bridge, {
			jnlpfile: '../CloudSuiteBridge/bridge.jnlp.jsp'
		}).then(function() {
			return bridge.connectRetry(-1);
		});
	};
	var bridgletParams = {
		factory: 'de.intarsys.cloudsuite.bridge.control.portal.AuthenticationBridglet',
		args: {
			challenge: bridgeParams.challenge
		}
	};

	// create a bridge stub
	var bridge = csBridge.lib.createBridge(bridgeParams);
	// try to inform and guide the user
	bridge.addEventListener('update', function(event) {
		updateInstructions(bridge);
	});
	//
	bridge
		// try to connect to the bridge agent
		.connect(launchFunction)
		// if we're connected, create bridglet
		.then(function(bridge) {
			window.onbeforeunload = function() {
				bridge.dispose(true);
				return undefined;
			};
			return bridge.createBridglet(bridgletParams);
		})
		// arm bridglet as needed and start
		.then(function(bridglet) {
			bridglet.addEventListener('ok', function(event) {
				bridglet.wantResultValue().then(function(resultValue) {
					sendOk(resultValue);
				});
			});
			bridglet.addEventListener('cancel', function(event) {
				sendCancel();
			});
			bridglet.addEventListener('fail', function(event) {
				console.info("cs: event fail " + JSON.stringify(event));
				sendCancel();
			});
			bridglet.enter();
		})
		//
		.then(undefined, function(e) {
			console.info("cs: error " + e);
			window.location = 'auth/nobridge.html';
		});
}

document.addEventListener('DOMContentLoaded', function() {
	document.getElementById('cancel').addEventListener('click', sendCancel);
	var bridgeParams = {};
	let tempUrl = toTargetUrl("../api/v1/authentication/getSmartcardParameters");
	send(tempUrl.toString(), request)//  
		.done(function(response) {
			$('#authLabel').empty();
			$('#authLabel').append(response.label);
			$('#authDescription').empty();
			$('#authDescription').append(response.description);
			bridgeParams.host = response.host;
			bridgeParams.portStop = response.portStart;
			bridgeParams.portStart = response.portStop;
			bridgeParams.license = {
				content: response.license
			};
			bridgeParams.challenge = response.challenge;
			$('#loading').hide();
			$('#content').show();
			startBridge(bridgeParams);
		}) //
		.fail(function(error) {
			$('#loading').hide();
			$('#failed').show();
			console.log("can not get parameters " + error);
		});
});