package de.intarsys.cloudsuite.gears.core.client;

import java.util.HashMap;
import java.util.Map;

/**
 * A stub encapsulates all information required to interact with a remote service.
 * 
 */
public abstract class CommonStub {

	/**
	 * The {@link Protocol} that is used for processing requests
	 */
	private final Protocol protocol;

	private final Map<String, String> additionalParameters = new HashMap<>();

	protected CommonStub(Protocol protocol) {
		this.protocol = protocol;
	}

	/**
	 * Clear all query parameters the should be added to an outgoing request.
	 */
	public void clearAdditionalParameters() {
		additionalParameters.clear();
	}

	protected Map<String, String> createParameters() {
		HashMap<String, String> map = new HashMap<>(getAdditionalParameters());
		return map;
	}

	/**
	 * Additional static query parameters to be added to outgoing requests.
	 */
	public Map<String, String> getAdditionalParameters() {
		return additionalParameters;
	}

	public Protocol getProtocol() {
		return protocol;
	}

	/**
	 * Remove a static query parameter.
	 * 
	 * @param key
	 */
	public void removeAdditionalParameter(String key) {
		additionalParameters.remove(key);
	}

	/**
	 * Add a static query parameter.
	 * 
	 * @param key
	 * @param value
	 */
	public void setAdditionalParameter(String key, String value) {
		additionalParameters.put(key, value);
	}
}
