package de.intarsys.cloudsuite.gears.core.client;

import java.util.List;
import java.util.stream.Stream;

import de.intarsys.cloudsuite.gears.core.service.common.api.TransportDocument;
import de.intarsys.cloudsuite.gears.core.service.explorer.api.RequestExplorerCreate;
import de.intarsys.cloudsuite.gears.core.service.explorer.api.ResponseExplorerCreate;
import de.intarsys.cloudsuite.gears.core.service.signer.api.RequestSignerCreate;
import de.intarsys.cloudsuite.gears.core.service.signer.api.ResponseSignerCreate;
import de.intarsys.cloudsuite.gears.core.service.timestamper.api.RequestTimestamperCreate;
import de.intarsys.cloudsuite.gears.core.service.timestamper.api.ResponseTimestamperCreate;
import de.intarsys.cloudsuite.gears.core.service.viewer.api.RequestViewerCreate;
import de.intarsys.cloudsuite.gears.core.service.viewer.api.ResponseViewerCreate;
import de.intarsys.tools.collection.ArrayTools;
import de.intarsys.tools.functor.IArgs;
import de.intarsys.tools.locator.ILocator;

/**
 * This stub interacts with the main gears API.
 * 
 */
public class GearsStub extends CommonStub {

	public GearsStub(Protocol protocol) {
		super(protocol);
	}

	public ExplorerStub createExplorer(IArgs options, Object configuration, IArgs variables, IArgs args,
			ILocator... locators)
			throws GearsServiceException {
		RequestExplorerCreate reqCreate = new RequestExplorerCreate();
		reqCreate.setConfiguration(configuration);
		reqCreate.setOptions(options);
		reqCreate.setVariables(variables);
		reqCreate.setArgs(args);
		for (ILocator locator : locators) {
			TransportDocument reqDoc = TransportDocument //
					.builder() //
					.content(locator) //
					.build();
			reqCreate.getDocuments().add(reqDoc);
		}
		ResponseExplorerCreate response = getProtocol().postJson(
				ExplorerStub.PATH_EXPLORER_CREATE,
				null /* headers */,
				createParameters(),
				reqCreate,
				ResponseExplorerCreate.class);
		return createExplorer(response);
	}

	public ExplorerStub createExplorer(IArgs options, Object configuration, IArgs variables, IArgs args,
			TransportDocument... documents)
			throws GearsServiceException {
		RequestExplorerCreate reqCreate = new RequestExplorerCreate();
		reqCreate.setConfiguration(configuration);
		reqCreate.setOptions(options);
		reqCreate.setVariables(variables);
		reqCreate.setArgs(args);
		for (TransportDocument doc : documents) {
			reqCreate.getDocuments().add(doc);
		}
		ResponseExplorerCreate response = getProtocol().postJson(
				ExplorerStub.PATH_EXPLORER_CREATE,
				null /* headers */,
				createParameters(),
				reqCreate,
				ResponseExplorerCreate.class);
		return createExplorer(response);
	}

	public ExplorerStub createExplorer(IArgs options, Object configuration, IArgs args, ILocator... locators)
			throws GearsServiceException {
		return createExplorer(options, configuration, null, args, locators);
	}

	public ExplorerStub createExplorer(IArgs options, Object configuration, IArgs args, TransportDocument... documents)
			throws GearsServiceException {
		return createExplorer(options, configuration, null, args, documents);
	}

	protected ExplorerStub createExplorer(ResponseExplorerCreate response) throws GearsServiceException {
		return new ExplorerStub(getProtocol(), response);
	}

	public SignerStub createSigner(IArgs options, Object configuration, IArgs variables, IArgs args,
			ILocator... locators)
			throws GearsServiceException {
		List<TransportDocument> documents = Stream.of(locators)
				.map(locator -> TransportDocument //
						.builder() //
						.content(locator) //
						.build())
				.toList();
		return createSigner(options, configuration, variables, args, ArrayTools.toArray(TransportDocument.class,
				documents));
	}

	public TimestamperStub createTimestamper(IArgs options, Object configuration, IArgs variables, IArgs args,
			TransportDocument... documents)
			throws GearsServiceException {
		RequestTimestamperCreate reqCreate = new RequestTimestamperCreate();
		reqCreate.setConfiguration(configuration);
		reqCreate.setOptions(options);
		reqCreate.setVariables(variables);
		reqCreate.setArgs(args);
		for (TransportDocument doc : documents) {
			reqCreate.getDocuments().add(doc);
		}
		return createTimestamper(reqCreate);
	}

	public SignerStub createSigner(IArgs options, Object configuration, IArgs variables, IArgs args,
			TransportDocument... documents)
			throws GearsServiceException {
		RequestSignerCreate reqCreate = new RequestSignerCreate();
		reqCreate.setConfiguration(configuration);
		reqCreate.setOptions(options);
		reqCreate.setVariables(variables);
		reqCreate.setArgs(args);
		for (TransportDocument doc : documents) {
			reqCreate.getDocuments().add(doc);
		}
		return createSigner(reqCreate);
	}

	public TimestamperStub createTimestamper(RequestTimestamperCreate reqCreate) throws GearsServiceException {
		return createTimestamper(getProtocol().postJson(
				TimestamperStub.PATH_TIMESTAMPER_CREATE,
				null /* headers */,
				createParameters(),
				reqCreate,
				ResponseTimestamperCreate.class));
	}

	public SignerStub createSigner(IArgs options, Object configuration, IArgs args, ILocator... locators)
			throws GearsServiceException {
		return createSigner(options, configuration, null, args, locators);
	}

	protected TimestamperStub createTimestamper(ResponseTimestamperCreate response) throws GearsServiceException {
		return new TimestamperStub(getProtocol(), response);
	}

	public TimestamperStub createTimestamper(IArgs options, Object configuration, IArgs args, ILocator... locators)
			throws GearsServiceException {
		return createTimestamper(options, configuration, null, args, locators);
	}

	public SignerStub createSigner(IArgs options, Object configuration, IArgs args, TransportDocument... documents)
			throws GearsServiceException {
		return createSigner(options, configuration, null, args, documents);
	}

	public SignerStub createSigner(RequestSignerCreate reqCreate) throws GearsServiceException {
		return createSigner(getProtocol().postJson(
				SignerStub.PATH_SIGNER_CREATE,
				null /* headers */,
				createParameters(),
				reqCreate,
				ResponseSignerCreate.class));
	}

	public TimestamperStub createTimestamper(IArgs options, Object configuration, IArgs variables, IArgs args,
			ILocator... locators)
			throws GearsServiceException {
		List<TransportDocument> documents = Stream.of(locators)
				.map(locator -> TransportDocument //
						.builder() //
						.content(locator) //
						.build())
				.toList();
		return createTimestamper(options, configuration, variables, args, ArrayTools.toArray(TransportDocument.class,
				documents));
	}

	protected SignerStub createSigner(ResponseSignerCreate response) throws GearsServiceException {
		return new SignerStub(getProtocol(), response);
	}

	public ViewerStub createViewer(IArgs options, Object configuration, IArgs variables, IArgs args, ILocator locator)
			throws GearsServiceException {
		RequestViewerCreate reqCreate;
		//
		reqCreate = new RequestViewerCreate();
		reqCreate.setConfiguration(configuration);
		reqCreate.setOptions(options);
		reqCreate.setVariables(variables);
		reqCreate.setArgs(args);
		TransportDocument transDoc = TransportDocument //
				.builder() //
				.content(locator) //
				.build();
		reqCreate.setDocument(transDoc);
		ResponseViewerCreate response = getProtocol().postJson(
				ViewerStub.PATH_VIEWER_CREATE,
				null /* headers */,
				createParameters(),
				reqCreate,
				ResponseViewerCreate.class);
		return createViewer(response);
	}

	public ViewerStub createViewer(IArgs options, Object configuration, IArgs args, ILocator locator)
			throws GearsServiceException {
		return createViewer(options, configuration, null, args, locator);
	}

	protected ViewerStub createViewer(ResponseViewerCreate response) throws GearsServiceException {
		return new ViewerStub(getProtocol(), response);
	}

}
