package de.intarsys.cloudsuite.gears.core.client;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.List;
import java.util.Map;

import de.intarsys.tools.string.StringTools;
import de.intarsys.tools.url.URLTools;

/**
 * This is a web page based stub, e.g. a simple web page with text content or a web 2.0 frontend. The stub represents
 * the redirect URL that was received from a conversational request.
 * 
 */
public abstract class PageStub extends CommonStub {

	private final String pageUrl;

	public PageStub(Protocol protocol, String pageUrl) {
		super(protocol);
		this.pageUrl = pageUrl;
	}

	@Override
	protected Map<String, String> createParameters() {
		Map<String, String> params = super.createParameters();
		String stickyId = getStickyId();
		if (stickyId != null) {
			params.put(getProtocol().getStickyFieldName(), stickyId);
		}
		return params;
	}

	public String getContentAsString() throws GearsServiceException {
		return getProtocol().get(
				getPageUrl(),
				null /* headers */,
				createParameters(),
				String.class);
	}

	public String getPageUrl() {
		return pageUrl;
	}

	protected String getStickyId() {
		String stickyFieldName = getProtocol().getStickyFieldName();
		if (StringTools.isEmpty(stickyFieldName)) {
			return null;
		}
		if (StringTools.isEmpty(getPageUrl())) {
			return null;
		}
		try {
			Map<String, List<String>> params = URLTools.getQueryParameters(new URL(getPageUrl()));
			List<String> values = params.get(stickyFieldName);
			if (values != null && !values.isEmpty()) {
				return values.get(0);
			}
		} catch (MalformedURLException e) {
			return null;
		}
		return null;
	}

}
