package de.intarsys.cloudsuite.gears.core.client;

import java.util.List;

import de.intarsys.cloudsuite.gears.core.service.common.api.TransportDocument;
import de.intarsys.cloudsuite.gears.core.service.signer.api.ResultSigner;
import de.intarsys.conversation.service.client.api.ConversationalResponse;
import de.intarsys.conversation.service.client.api.DtoResultStage;

/**
 * The "signer" service from gears.
 * 
 */
public class SignerStub extends ConversationStub {

	public static final String PATH_SIGNER_CREATE = "/api/v1/flow/signer/create";

	public SignerStub(Protocol protocol, ConversationalResponse response) throws GearsServiceException {
		super(protocol, response);
	}

	public TransportDocument getSignature(int i) {
		DtoResultStage resultStage = (DtoResultStage) getReplyStage();
		ResultSigner resultSigner = (ResultSigner) resultStage.getResult();
		return resultSigner.getSignatures().get(i);
	}

	public List<TransportDocument> getSignatures() {
		DtoResultStage resultStage = (DtoResultStage) getReplyStage();
		ResultSigner resultSigner = (ResultSigner) resultStage.getResult();
		return resultSigner.getSignatures();
	}

}
