package de.intarsys.cloudsuite.gears.core.client.auth;

import java.util.Base64;

import org.ietf.jgss.GSSContext;
import org.ietf.jgss.GSSCredential;
import org.ietf.jgss.GSSException;
import org.ietf.jgss.GSSManager;
import org.ietf.jgss.GSSName;
import org.ietf.jgss.Oid;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import jakarta.ws.rs.client.Invocation.Builder;
import jakarta.ws.rs.core.HttpHeaders;

/**
 * This authenticator supports the Kerberos protocol.
 * 
 */
public class KerberosAuthenticator extends CommonAuthenticator {

	private static final Logger Log = LoggerFactory.getLogger(KerberosAuthenticator.class);

	private static Oid OID_SPNEGO;

	static {
		try {
			OID_SPNEGO = new Oid("1.3.6.1.5.5.2");
		} catch (GSSException ignore) {
			// not expected (oid string known to be valid)
		}
	}

	private String host;

	public KerberosAuthenticator() {
		super();
	}

	@Override
	public Builder process(Builder builder) {
		GSSManager manager = GSSManager.getInstance();
		try {
			GSSName name = manager.createName("HTTP@" + host, GSSName.NT_HOSTBASED_SERVICE);
			GSSCredential cred = manager.createCredential(name, GSSCredential.DEFAULT_LIFETIME, OID_SPNEGO,
					GSSCredential.ACCEPT_ONLY);
			GSSContext context = manager.createContext(name, OID_SPNEGO, cred, GSSCredential.DEFAULT_LIFETIME);
			byte[] token = context.initSecContext(new byte[0], 0, 0);
			builder.header(HttpHeaders.AUTHORIZATION, "Negotiate " + Base64.getEncoder().encodeToString(token));
		} catch (GSSException ex) {
			Log.warn(ex.getMessage(), ex);
		}
		return builder;
	}

}
