#!/bin/bash
# -----------------------------------------------------------------------------
# Sign Live! CC start script.
# version 7.1.9.1
#
# copyright intarsys GmbH
# <support@intarsys.de>
#
# 
# This script offers similar functions as the launcher 'signlivecc' does.
# It may be useful for linux installations where the launcher does not work.
# It does the following:
#
# 1) detects a JAVA runtime environment considering the following precedence
#    1. If $SLCC_HOME/jre exists and contains a JRE, take this.
#    2. If $CABARET_JAVA_HOME is set and points to a JRE, take this.
#    3. If $JAVA_HOME is set and points to a JRE, take this.
#    otherwise evaluate the expression 'java'
# 2) changes the actual directory to the SLCC installation directory $SLCC_HOME
# 3) starts Sign Live! CC considering
#	the JRE options set in signlivecc.vmoptions
#       the parameters given to this script
#
#  Important:
#  This script cannot transfer commands to an already running SLCC instance
#  as the launcher does.
#
# examples
#
# starting SLCC in GUI mode
# /opt/intarsys/signlivecc-7.1.9.1/bin/signlivecc.sh
#
# starting SLCC in GUI mode using a user specific configuration
# /opt/intarsys/signlivecc-7.1.9.1/bin/signlivecc.sh -config config/myconfig.conf
#
# starting SLCC in GUI mode using a user specific profile directory
# /opt/intarsys/signlivecc-7.1.9.1/bin/signlivecc.sh -profile .signlivecc-7.1
#
# starting SLCC headless (without GUI)
# /opt/intarsys/signlivecc-7.1.9.1/bin/signlivecc.sh -launch headless block -config ...
#
#
# -----------------------------------------------------------------------------

# needed for unity
LIBOVERLAY_SCROLLBAR=0
UBUNTU_MENUPROXY=0
export LIBOVERLAY_SCROLLBAR
export UBUNTU_MENUPROXY


PROGID=signlivecc
echo pwd=`pwd`

# calculate PROG_HOME directory in relation to this script
# resolve links - $0 may be a softlink (including relative links)
PROGDIR=`dirname "$0"`
PROG=`cd "$PROGDIR" ; pwd`/`basename "$0"`
while [ -h "$PROG" ]; do
  ls=`ls -ld "$PROG"`
  link=`expr "$ls" : '.*-> \(.*\)$'`
  if expr "$link" : '/.*' > /dev/null; then
    PROG="$link"
  else
    PROG=`dirname "$PROG"`/"$link"
  fi
done

PROGDIR=`dirname "$PROG"`
PROG_HOME=`cd "$PROGDIR/.." ; pwd`
export PROG_HOME


echo PROG=$PROG
echo PROG_HOME=$PROG_HOME

cd "$PROG_HOME"
export LD_LIBRARY_PATH=$LD_LIBRARY_PATH:$PROG_HOME/lib/amd64

MY_CLASSPATH="$PROG_HOME/classes"
for i in `ls $PROG_HOME/lib/*.jar`
do
  MY_CLASSPATH=$MY_CLASSPATH:$i
done


# detect JAVA environment
MY_JAVA_HOME=""
# try $JAVA_HOME
if [  -x "$JAVA_HOME/bin/java" ]
then
  MY_JAVA_HOME=$JAVA_HOME
  echo '$JAVA_HOME' exists as $JAVA_HOME 
fi
# try $CABARET_JAVA_HOME
if [  -x "$CABARET_JAVA_HOME/bin/java" ]
then
  MY_JAVA_HOME=$CABARET_JAVA_HOME
  echo '$CABARET_JAVA_HOME' exists as $CABARET_JAVA_HOME 
fi
# try $PROG_HOME/jre
if [  -x "$PROG_HOME/jre/bin/java" ]
then
  MY_JAVA_HOME=$PROG_HOME/jre
  echo '$PROG_HOME/jre' exists 
fi
# try default
if [ -z "$MY_JAVA_HOME" ]
then
  MY_JAVA=java
else
  MY_JAVA=$MY_JAVA_HOME/bin/java
fi

# JAVA_OPTS
JAVA_OPTS=""
if [ -r "$PROG_HOME/bin/$PROGID.vmoptions" ]
then
  JAVA_OPTS=`cat $PROG_HOME/bin/$PROGID.vmoptions`
fi

echo JAVA=$MY_JAVA
# echo MY_CLASSPATH=$MY_CLASSPATH
echo JAVA_OPTS=$JAVA_OPTS
echo params=$*

"$MY_JAVA" \
    -classpath "$MY_CLASSPATH" $JAVA_OPTS com.cabaret.claptz.stage.main.StandardStage \
    $*

