#! /bin/sh

# -----------------------------------------------------------------------------
# Sign Live! CC System-V style init script
# version 7.1.9.1
#
# copyright intarsys GmbH
# <support@intarsys.de>
#
# Use this script to execute SLCC as a service even if no user is logged on.
#
# Usage:
# 1) create a link named 'signlivecc' to this script in /etc/init.d
# 	  ln -s /opt/intarsys/signlivecc-7.1.9.1/bin/signlivecc_service.sh /etc/init.d/signlivecc
# 2) register the link for the defined run levels
#	    --> SLCC will start automatically at system start
#	    'chkconfig --add signlivecc'
#
# Hints/restrictions:
# - To run SLCC in the headless mode, a license key needs to be installed.
#   Otherwise SLCC does not start.
# - To define JVM options use the file 'signlivecc.vmoptions'.
# - To register again with different run levels first remove the old links with
#	   'chkconfig --del signlivecc'
# - The SLCC launcher 'signlivecc' is capable to control o n e  service per user.
#   I.e. to run more than one SLCC service or
#   to run SLCC parallelly in headless and in GUI mode use different users.
#


### BEGIN INIT INFO
# Provides: signlivecc
# Required-Start: 
# Required-Stop: 
# Should-Start: $network pcscd 
# Should-Stop: 
# Default-Start: 2 3 4 5
# Default-Stop: 0 1 6
# Short-Description: Sign Live CC server service
# Description: Sign Live CC server service
### END INIT INFO


# calculate launcher in relation to this script
# resolve links - $0 may be a softlink (including relative links)
PROGNAME="Sign Live! CC"
PROGID=signlivecc
PROGDIR=`dirname "$0"`
PROG=`cd "$PROGDIR" ; pwd`/`basename "$0"`
while [ -h "$PROG" ]; do
  ls=`ls -ld "$PROG"`
  link=`expr "$ls" : '.*-> \(.*\)$'`
  if expr "$link" : '/.*' > /dev/null; then
    PROG="$link"
  else
    PROG=`dirname "$PROG"`/"$link"
  fi
done

PROGDIR=`dirname "$PROG"`
PROG=$PROGDIR/$PROGID

if [ ! -x $PROG ]
then
    echo $PROGNAME launcher $PROG is not executable.
    exit 1
fi

case "$1" in
    start)
	   nohup sh -c "exec $PROG -cf bin/service.cli" 1>>/dev/null 2>>/dev/null &
	   echo $PROGNAME started [$PROG].
	   echo
        ;;
    stop)
	   nohup sh -c "exec $PROG -e" 1>>/dev/null 2>>/dev/null &
	   echo $PROGNAME stopped [$PROG].
     echo
        ;;
    restart)
        $0 stop
        sleep 10
        $0 start
        ;;
    status)
        USER=`whoami`
        PROCESS=`ps -U $USER -u $USER u | grep "$PROG -cf" | grep -v grep`
	      if [ -z "$PROCESS" ]
	      then
	        echo $PROGNAME launcher $PROG is  N O T  running under user $USER.
            # 3=service was stopped
	        exit 3 
	      else
	        echo $PROGNAME launcher $PROG is running under user $USER.
	        echo
	        echo $PROCESS
	        echo
	      fi
        ;;
    *)
        echo "Usage: $0 {start|stop|restart|status}"
        exit 1
        ;;
esac

exit 0
