#!/bin/bash
# -----------------------------------------------------------------------------
# Sign Live! CC service start script.
# version 7.1.9.1
#
# copyright intarsys GmbH
# <support@intarsys.de>
#
# 
# This script starts SLCC with its separate service configuration set in GUI mode.
#
# -----------------------------------------------------------------------------


# calculate PROG_HOME directory in relation to this script
# resolve links - $0 may be a softlink (including relative links)
PROGDIR=`dirname "$0"`
PROG=`cd "$PROGDIR" ; pwd`/`basename "$0"`
while [ -h "$PROG" ]; do
  ls=`ls -ld "$PROG"`
  link=`expr "$ls" : '.*-> \(.*\)$'`
  if expr "$link" : '/.*' > /dev/null; then
    PROG="$link"
  else
    PROG=`dirname "$PROG"`/"$link"
  fi
done

PROGDIR=`dirname "$PROG"`
PROG_HOME=`cd "$PROGDIR/.." ; pwd`
export PROG_HOME

# needed for unity
LIBOVERLAY_SCROLLBAR=0
UBUNTU_MENUPROXY=0
export LIBOVERLAY_SCROLLBAR
export UBUNTU_MENUPROXY


"$PROG_HOME/bin/signlivecc" -config "config/service.config"
