// get the current batch run
var batchRun = cli.peek();
// determine report files
var htmlFile = batchRun.expand('${batch.path}/${batch.name}/${run.start:d}/report.html');
var pdfFile = batchRun.expand('${batch.path}/${batch.name}/${run.start:d}/report.pdf');
// create HTML report
var reportDocHTML = CodeExit.callArgs(
	"Action",
	"com.cabaret.batch.report.report", {
	batch: batchRun
});
var reportLocatorHTML = Packages.de.intarsys.document.common.DocumentLocatorFactory.get().createLocator(htmlFile);
reportDocHTML.save(reportLocatorHTML);
// create PDF report
var reportDocPDF = Processor.callArgs(
	'com.cabaret.pdf.exchange.html.HTMLImporterFactory', {
	importLocator: reportLocatorHTML
});
var reportLocatorPDF = Packages.de.intarsys.document.common.DocumentLocatorFactory.get().createLocator(pdfFile);
reportDocPDF.save(reportLocatorPDF);
// no return value
null;
