/***************************************************************************************************
	Number formats
***************************************************************************************************/

function AFNumber_Format(decimals, separator, negativeFlags, dummy, currencyTag, leading) {       
	Packages.com.cabaret.scripting.javascript.application.scriptable.pdf.LibAcroForm.jsNumberFormat(this, decimals, separator, negativeFlags, dummy, currencyTag, leading);
}

function AFNumber_Keystroke(decimals, separator, negativeFlags, dummy, currencyTag, leading) {   

	/*
    console.println("hello " + event.value);
    console.println("field f1 " + this.getField("f1"));
    */
    
	Packages.com.cabaret.scripting.javascript.application.scriptable.pdf.LibAcroForm.jsNumberKeystroke(this, decimals, separator, negativeFlags, dummy, currencyTag, leading);
}

/***************************************************************************************************
	Percent formats
***************************************************************************************************/

function AFPercent_Format(decimals, separator) {       
	Packages.com.cabaret.scripting.javascript.application.scriptable.pdf.LibAcroForm.jsPercentFormat(this, decimals, separator);
}

function AFPercent_Keystroke(decimals, separator) {       
	Packages.com.cabaret.scripting.javascript.application.scriptable.pdf.LibAcroForm.jsPercentKeystroke(this, decimals, separator);
}

/***************************************************************************************************
	Date formats
***************************************************************************************************/

function AFDate_Keystroke(index) {       
	if (event.willCommit) {
		return;
	}
	var value = event.change;
	if (isControl(value) || isDigit(value) || value == '.' ||  value == ':' ||  value == '-' || value == ' ') {
		return;
	}
	app.beep(0);
	event.rc = false;
}

function AFDate_KeystrokeEx(pattern) {       
	if (event.willCommit) {
		return;
	}
	var value = event.change;
	if (isControl(value) || isDigit(value) || value == '.' ||  value == ':' ||  value == '-' || value == ' ') {
		return;
	}
	app.beep(0);
	event.rc = false;
}

function AFDate_FormatEx(pattern) {       
	Packages.com.cabaret.scripting.javascript.application.scriptable.pdf.LibAcroForm.jsDateFormat(this, pattern);
}

function AFDate_Format(index) {       
	/* deprecated */
	Packages.com.cabaret.scripting.javascript.application.scriptable.pdf.LibAcroForm.jsDateFormat(this, index);
}


/***************************************************************************************************
	Time formats
***************************************************************************************************/

function AFTime_Keystroke(dummy) {       
	if (event.willCommit) {
		return;
	}
	var value = event.change;
	if (isControl(value) || isDigit(value) || value == '.' ||  value == ':' ||  value == '-' || value == ' ') {
		return;
	}
	app.beep(0);
	event.rc = false;
}

function AFTime_FormatEx(pattern) {       
	Packages.com.cabaret.scripting.javascript.application.scriptable.pdf.LibAcroForm.jsTimeFormat(this, pattern);
}

function AFTime_Format(index) {       
	/* deprecated */
	Packages.com.cabaret.scripting.javascript.application.scriptable.pdf.LibAcroForm.jsTimeFormat(this, index);
}


/***************************************************************************************************
	Special formats
***************************************************************************************************/

function AFSpecial_Format(index) {       
	Packages.com.cabaret.scripting.javascript.application.scriptable.pdf.LibAcroForm.jsSpecialFormat(this, index);
}

function AFSpecial_Keystroke(index) {       
	Packages.com.cabaret.scripting.javascript.application.scriptable.pdf.LibAcroForm.jsSpecialKeystroke(this, index);
}

function AFSpecial_KeystrokeEx(pattern) {       
	Packages.com.cabaret.scripting.javascript.application.scriptable.pdf.LibAcroForm.jsSpecialKeystrokeEx(this, pattern);
}


/***************************************************************************************************
	Validation
***************************************************************************************************/

function AFRange_Validate(checkLower, lower, checkUpper, upper) {       
	if (event.value == null || event.value == "") {
		return;
	}
	if (checkLower) {
		if (event.value < lower) {
			event.rc = false;
		}
	}
	if (checkUpper) {
		if (event.value > upper) {
			event.rc = false;
		}
	}
	
}

/***************************************************************************************************
	Calculation
***************************************************************************************************/

function AFSimple_Calculate(operator, fields) {       
	return 	Packages.com.cabaret.scripting.javascript.application.scriptable.pdf.LibAcroForm.jsSimpleCalculate(this, operator, fields);
}

/***************************************************************************************************
	Util
***************************************************************************************************/

function AFMakeNumber(value) {
	return 	Packages.com.cabaret.scripting.javascript.application.scriptable.pdf.LibAcroForm.jsMakeNumber(this, value);
}


function isDigit(character) {
	return character >= '0' && character <= '9'
}

function isControl(character) {
	return character <= ' ' || character == 0x7f
}

