var log = Packages.de.intarsys.tools.yalf.common.LogTools.getLogger("default");
log.trace("starting script " + Reflector.locator().getFullName());

var argCount = Reflector.argCount();
if (argCount < 1 || argCount > 2) {
	throw("invalid argument count");
}

Reflector.declareArg("batch");
Reflector.declareArg("format", "HTML");

/* generate the report for the validation state */
var reportString = Resolver.reportBatch(batch);
if (reportString == null ) {
	throw("report generation failed");
}

var result;
if (format == "PDF") {
	var locator = new Packages.de.intarsys.tools.locator.StringLocator(reportString , "html report", "html");
	result = Processor.callArgs(
		"com.cabaret.pdf.exchange.html.HTMLImporterFactory", {
		importLocator: locator
	});		
} else {
	var documentType = jDocumentOutlet.lookupDocumentType("com.cabaret.document.html.HTMLDocumentType"); 
	result = documentType.createFromImpl(null, reportString);
}
if (result == null ) {
	throw("report generation failed");
}

// return report
result;
