var log = Packages.de.intarsys.tools.yalf.common.LogTools.getLogger("default");
log.trace("starting script " + Reflector.locator().getFullName());

var argCount = Reflector.argCount();
if (argCount < 1 || argCount > 2) {
	throw("invalid argument count");
}

Reflector.declareArg("document");
Reflector.declareArg("format", "HTML");

/* generate the report for the validation state */
var report = Resolver.reportPDFCommon(document.impl);
if (report == null ) {
	throw("report data generation failed");
}

var tools = Packages.de.intarsys.document.common.DocumentTools;
var locator = report.locator;
locator.rename("DocumentReport - " + document.shortName + "." + locator.type);
var result;
if (format == "PDF") {
	result = Processor.callArgs(
		"com.cabaret.pdf.exchange.html.HTMLImporterFactory", {
		importLocator: locator
	});		
} else {
	result = tools.createFromLocator(locator, null);
}
if (result == null ) {
	throw("report document generation failed");
}

// we should link the result in some generic way to the document
tools.setMaster(result, document);

// return report
result;
