/*
    __
   /  \        intarsys GmbH (c)
   \__/
     |\/|
     |  |
   intarsys
     |__|

This creates a report over all signatures of a single
PDF document. 

in: 
  document mandatory IDocument 
  format optional PDF or HTML (default HTML)
  append optional true or false (default false)
out: 
  the validation report object (either HTML string or PDF document).
 
*/

var path = "messages";   
var classpath = Reflector.locator().parent.fullName + "/resources";
var MSG = Packages.de.intarsys.tools.message.MessageTools.getMessageBundle(path, classpath);

var ValidationProduct = Packages.com.cabaret.security.document.validation.ValidationProduct;
if (!ValidationProduct.isAuthorizedValidate()) {
	Packages.de.intarsys.tools.reporter.Reporter.get().reportMessage(MSG.getString("report.LicenseCheck.Title"), MSG.getString("report.LicenseCheck.Message"), 0);
}

var log = Packages.de.intarsys.tools.yalf.common.LogTools.getLogger("default");
log.trace("starting script " + Reflector.locator().getFullName());

var argCount = Reflector.argCount();
if (argCount < 1 || argCount > 4) {
	throw("invalid argument count");
}

Reflector.declareArg("document");
Reflector.declareArg("format", "HTML");
Reflector.declareArg("append", false);
Reflector.declareArg("pdfaCompliant", true);

/* generate the report for the validation state */
var reportData = new Packages.de.intarsys.stage.report.model.Report(document);
var reportString = Resolver.reportPDFSignatureValidation({ reportData: reportData });
if (reportString == null ) {
	throw("report generation for signature validation failed");
}

var idoc = reportData.idoc;
if (append == true) {
	if (idoc == null || Packages.com.cabaret.document.pdf.PDFDocumentType.ID != idoc.type.id) {
		append = false;
	}
}

var result = null;
var locator = new Packages.de.intarsys.tools.locator.StringLocator(reportString , "html report", "html");
if (format=="PDF") {
	var importedIDoc = Processor.callArgs(
		"com.cabaret.pdf.exchange.html.HTMLImporterFactory", {
		importLocator: locator,
		embedFonts: pdfaCompliant
	});		
	if (importedIDoc == null ) {
		throw("HTML import for signature validation protocol failed");
	}
	
	if (pdfaCompliant) {
		var fix = new Packages.de.intarsys.pdf.xmp.PDFixGenerateXMP(this, importedIDoc.getImpl());
		// comment this if we are not able to create a PDF/A compliant pddoc
		fix.setAttribute(Packages.de.intarsys.pdf.xmp.PDFixGenerateXMP.ATTR_PDFA_XMP, "do");
		fix.perform();
		
		Packages.de.intarsys.pdf.fixes.PDFixTools.quickFix(importedIDoc.getImpl());
	}

	result = importedIDoc;
	if (append==true)  {
		Processor.callArgs(
			"com.cabaret.pdf.processor.pageimporter.PageImporterFactory", { 
			document: idoc,
			sourceDocument: importedIDoc,
			documentPage: 'last',
			documentBeforeAfter: 'after',
			sourceDocumentPageRange: 'all'
		} );
		importedIDoc.release(null);
		// acquire here to allow client code to safely release in all cases.
		idoc.acquire();
		result = idoc;
	}
} else {
	result = Packages.de.intarsys.document.common.DocumentTools.load(locator);
}

// return the validation report
result;
