/*
    __
   /  \        intarsys GmbH (c)
   \__/
     |\/|
     |  |
   intarsys
     |__|

This script signs a single BMU EANV compliant XML document. 
Schema validation is not applied by default.
Change the loadX method if schema validation should be applied.

Parameters:
	In:
		- document : path to the document to be signed
		- layerId : id of the layer to be signed
	Out:
		- nothing
*/

var xmldoc = loadDocumentWithoutSchema(document);
try {
	sign(xmldoc, layerId);
} finally {
	xmldoc.release(null);
}


function loadDocumentWithoutSchema(documentPath) {
	return Processor.callArgs('com.cabaret.application.document.processor.DocumentLoaderFactory',
			{ 
				locator : documentPath
			});
}

function loadDocumentWithEANVSchema(documentPath) {
	return Processor.callArgs('com.cabaret.application.document.processor.DocumentLoaderFactory',
			{ 
				locator : documentPath,
				schemaName: 'eANV'
			});
}

function sign(xmldoc, layerId) {
	var signature = Wizard.callArgs(
		  'com.cabaret.security.method.xml.signing.XMLDocumentSignerWizardFactory',
		  {
		    document: xmldoc,
		    viewDocument: false,
		    
		    namespaces: getNamespaces(),
		 
		    /** ds:signature node will be placed at the location specified here in xpath */
		    parentNodeLookup: getParentNodeLookup(layerId), 

		    /** ds:signature id */ 
		    signatureElementId: generateExtendedUUID(layerId),
		    
		    /** specify what to sign as an array of maps */  
		    references: [ getSignedLayerReference(layerId) ],
		    
		    /** specify the signature format, which is RFC4050 for eANV*/
		    format: "XAdES/RFC4050"
		  }
		);
	return signature;
}

function getNamespaces(){
	return {
		msg : "uri:BMU_Waste_Interface/Message",
		lib : "uri:BMU_Waste_Interface/Bibliothek",
		en  : "uri:BMU_Waste_Interface/EN",
		bgs : "uri:BMU_Waste_Interface/BGS",
		ds  : "http://www.w3.org/2000/09/xmldsig#",
		xf  : "http://www.w3.org/2002/06/xmldsig-filter2",
		xd  : "http://uri.etsi.org/01903/v1.3.2#",
		ecdsa : "http://www.w3.org/2001/04/xmldsig-more#"
	};
}

function getParentNodeLookup(layerId) {
	return "//*[@lib:LayerID='" + layerId + "']";
}

function generateExtendedUUID(layerId) {
	var uuid = java.util.UUID.randomUUID().toString().toUpperCase();
	return parseRoleMnemonic(layerId) + '-' + uuid;
}

function parseRoleMnemonic(layerId) {
	if(layerId.length != 43) {
		throw  "Illegal uuid '" + layerId + "'";
	}
	return layerId.substring(0, 3);
}

function getSignedLayerReference(layerId) {
	return {
    	uri: "",
       	transforms: [
        		{ 
        		  algorithm: "http://www.w3.org/2000/09/xmldsig#enveloped-signature"  		
        		},
        		{ 
        		  algorithm: "http://www.w3.org/2002/06/xmldsig-filter2",
        		  filter: "intersect",
        		  expression: "here()/ancestor::*[6]"
        		},
        		{ 
          		  algorithm: "http://www.w3.org/2002/06/xmldsig-filter2",
          		  filter: "subtract",
          		  expression: "here()/ancestor::*[6]/*[namespace-uri()='http://www.w3.org/2000/09/xmldsig#' and local-name()='Signature']"
          		},
        		{ 
    			  algorithm: "http://www.w3.org/2001/10/xml-exc-c14n#"
        		}
        	]
        };
}
