/********************************************
 *	intarsys GmbH
 *	all rights reserved
 ********************************************/
 
/*
*	opens a file chooser and set variables for the chosen image
*     
*   in:
*       none
*	out:
*       none
*/

var log = Packages.de.intarsys.tools.yalf.common.LogTools.getLogger("com.cabaret.security.app.signing");
chooseImage();

function chooseImage() {

	try {
		log.trace("starting script " + Reflector.locator().getFullName());

		var extensions = ["*.png", "*.*"];
		var names = ["PNG-Dateien", "Alle Dateien"];
		var imageFolder = Packages.de.intarsys.tools.variable.VariableNamespaces.get().getNamespace("user").getVariable("signatureAdditionsImageFolder");
		var iconFileName = Packages.com.cabaret.claptz.common.ui.UITools.queryFilenameLoad("Signaturdarstellungen", extensions, names, imageFolder);

		if(iconFileName != null) {
			var iconFile = new Packages.java.io.File(iconFileName);
			Packages.de.intarsys.tools.variable.VariableNamespaces.get().getNamespace("user").putVariable("signatureAdditionsImageFolder", iconFile.parentFile.absolutePath);
			Packages.de.intarsys.tools.variable.VariableNamespaces.get().getNamespace("user").putVariable("signatureAdditionsImageName", iconFile.name);
		}
	} catch(e) {
		var javaException = e.javaException;
		if(!(javaException instanceof Packages.de.intarsys.scripting.api.ScriptError)
			|| !(javaException.cause instanceof Packages.de.intarsys.tools.functor.FunctorCancelledException)) {
			app.alert(e);
		}
	}
	log.trace("ending script " + Reflector.locator().getFullName());
}
