/********************************************
 *	intarsys GmbH
 *	all rights reserved
 ********************************************/
 
/*
*	opens a the wizard to position a new signature field
*     
*   in:
*       none
*	out:
*       none
*/

var log = Packages.de.intarsys.tools.yalf.common.LogTools.getLogger("com.cabaret.security.app.signing");

if (jEvent.target == null) {
	app.alert("please open the document to be archived");
} else {
	sign();
}


function sign() {

	try {
		log.trace("starting script " + Reflector.locator().getFullName());

		var extensions = ["*.png", "*.*"];
		var names = ["PNG-Dateien", "Alle Dateien"];
		var imageFolder = Packages.de.intarsys.tools.variable.VariableNamespaces.get().getNamespace("user").getVariable("signatureAdditionsImageFolder");
		var iconFileName = Packages.com.cabaret.claptz.common.ui.UITools.queryFilenameLoad("Signaturdarstellungen", extensions, names, imageFolder);

		if(iconFileName != null) {
			var iconFile = new Packages.java.io.File(iconFileName);
			Packages.de.intarsys.tools.variable.VariableNamespaces.get().getNamespace("user").putVariable("signatureAdditionsImageFolder", iconFile.parentFile.absolutePath);
			Packages.de.intarsys.tools.variable.VariableNamespaces.get().getNamespace("user").putVariable("signatureAdditionsImageName", iconFile.name);

			var document = jEvent.target.document;
			var documentName = document.longName;
			var documentShortName = document.locator.typedName;

			Wizard.callArgs("com.cabaret.security.document.signing.ui.DocumentSignerWizardFactory", {
					"documentSigner": {
						"factory": "com.cabaret.security.method.pdf.signing.PDFDocumentSignerFactory",
						"args": {
							"field": {
								"create": "true",
								"adjustForRotate": "true"
							},
							"showPositionPage": "true",
							"decorator": {
								"factory": "com.cabaret.security.method.pdf.signing.decorator.ExtendedDecoratorFactory",
								"args": {
									"icon": iconFileName
								}
							}
						}
					},
					"document": document
			});
		}

	} catch(e) {
		var javaException = e.javaException;
		if(!(javaException instanceof Packages.de.intarsys.scripting.api.ScriptError)
			|| !(javaException.cause instanceof Packages.de.intarsys.tools.functor.FunctorCancelledException)) {
			app.alert(e);
		}
	}

	log.trace("ending script " + Reflector.locator().getFullName());
}


