/********************************************
 *	intarsys GmbH
 *	all rights reserved
 ********************************************/
 
/*
*	opens a the wizard to position a hidden signature field
*     
*   in:
*       none
*	out:
*       none
*/

var log = Packages.de.intarsys.tools.yalf.common.LogTools.getLogger("com.cabaret.security.app.signing");

if (jEvent.target == null) {
	app.alert("please open the document to be archived");
} else {
	signHidden();
}

function signHidden() {

	try {
		log.trace("starting script " + Reflector.locator().getFullName());

		var document = jEvent.target.document;
		var documentName = document.longName;
		var documentShortName = document.locator.typedName;

		Wizard.callArgs("com.cabaret.security.document.signing.ui.DocumentSignerWizardFactory", {
				"documentSigner": {
					"factory": "com.cabaret.security.method.pdf.signing.PDFDocumentSignerFactory",
					"args": {
						"showPositionPage": false,
						"field": {
							"create": true,
							"visible": false
						}
					}
				},
				"document": document,
		});
	} catch(e) {
		var javaException = e.javaException;
		if(!(javaException instanceof Packages.de.intarsys.scripting.api.ScriptError)
			|| !(javaException.cause instanceof Packages.de.intarsys.tools.functor.FunctorCancelledException)) {
			app.alert(e);
		}
	}
	log.trace("ending script " + Reflector.locator().getFullName());
}
