try {
	var ServiceContext = Packages.de.intarsys.service.common.ServiceContext;
	var tempId = ServiceContext.service.serviceConfig.serviceContainer.id;
	var tempLogger = _service.getAttribute("logger");
	tempLogger.info("smartcard pool signature service intialize...");
	var tempRegistry = Packages.de.intarsys.security.device.pool.device.PoolRegistry.get();
	if (tempRegistry == null) {
		throw new Error("Signature pool registry missing");
	}
	var tempPoolId = ServiceContext.service.pool;
	if (tempPoolId == null) {
		tempLogger.info("smartcard pool - no static pool declaration");
	} else {
		var tempPool = tempRegistry.lookupPool(tempPoolId);
		if (tempPool == null) {
			throw new Error("Signature pool '" + tempPoolId + "' missing");
		}
		if (tempPool.started) {
			tempLogger.info("smartcard pool '" + tempPoolId + "' already started");
		} else {
			if (tempPool.autoStart) {
				tempLogger.info("smartcard pool '" + tempPoolId + "' start...");
				tempPool.start();
				tempLogger.info("smartcard pool '" + tempPoolId + "' started");
			} else {
				throw new Error("Signature pool '" + tempPoolId + "' not started");
			}
		}
	}
	tempLogger.info("smartcard pool signature service intialized");
} catch(e) {
	tempLogger.info("smartcard pool signature service intialization failed (" + e + ")");
	throw e; 
}
